// LinksManager.h: interface for the CLinksManager class.
//
//////////////////////////////////////////////////////////////////////
#pragma once

#include "exceptions.h"
#include "singletons.h"
#include "links.h"
#include "FTNStruc.hpp"

class CLinksManager : public CSingleton
{
public:
	virtual ~CLinksManager();

	static CLinksManager* getInstance() throw(CBadConfigException)
	{
		static CLinksManager	linksManager;

		if (!linksManager.loaded) {
			linksManager.load();
		}

		return &linksManager;
	}

	int		getLinkCount() const { return links.size(); }
	PLink	getLink(int index)   { return links[index]; }

	PLink	getLink(const SFTNAddress& addr);

	class CIterator {
	public:
		CIterator();
		CIterator(CLinksManager* aManager, int anIndex);
		CIterator(const CIterator& instance);
		virtual ~CIterator() {}

		CIterator& operator =(const CIterator& instance);

		bool operator ==(const CIterator& instance);
		bool operator !=(const CIterator& instance);

		CIterator& operator ++();
		PLink operator *();

	protected:
		CLinksManager*	manager;
		int				index;
	};

	CIterator	begin();
	CIterator	end();

	void addLink(PLink newLink) { links.push_back( newLink ); }

	static bool parseLinkAddress(const char* s, SFTNAddress& address);
	static void chooseAKA(PLink link);

	/**
	 * Sets linksChanged flag to save links on exit
	 */
	void affectLinks() { linksChanged = true; }

	// TODO: we don't need group numbers anymore; methods can be removed when we remove all numbers
	static unsigned long getGroupNumber(const tstring& groupName);
	static const tstring getGroupName(unsigned long groupNumber);

	// obligatory singleton methods

	virtual void destroy() {
		if (linksChanged) {
			saveLinks();
		}
	}

	virtual CSingletonVector getDependencies() { return CSingletonVector(); }

protected:
	CLinksManager();
	vector<PLink>	links;
	bool			linksChanged;

	bool			loaded;

	void load() throw(CBadConfigException);
	void saveLinks() throw(CIOException, CRuntimeException);
};
typedef CLinksManager*	LinksManagerPtr;
